

#include <string.h>
#include "main.h"



const unsigned char  UART_AT[2] = {"AT"};

const unsigned char  UART_Receive_OK[2] = {"OK"};
const unsigned char  UART_Receive_CommandFail[12] = {"Command_Fail"};

const unsigned char  UART_NEWLine[1] = {13};
const unsigned char  UART_Tab[1] = {9};
const unsigned char  UART_Comma[1] = {44};


s8		UART_Buffer[40];

/************************************************************************************************************
  * @brief  URAT_TimerCounter
  * @retval None
  ***********************************************************************************************************/
void URAT_TimerCounter(void)
{
	if(F_UR0RxTimeOut)
	{
		F_UR0RxTimeOut = 0;
		F_UR0RxBegin = 0;
		F_UR0RxDataComing = 1;	
	}
}
/************************************************************************************************************
  * @brief  UART_SendNEWLine
  * @retval None
  ***********************************************************************************************************/
void UART_SendNEWLine(void)
{
	URTxWriteIndex = sizeof(UART_NEWLine);
	memcpy(URTxBuf, UART_NEWLine, URTxWriteIndex);
	USART_IntConfig(COM1_PORT, USART_INT_TXDE, ENABLE);
	while(F_UR0TxComplete == 0){}
		F_UR0TxComplete = 0;
	memset(UART_Buffer, 0, sizeof(UART_Buffer));
}

/************************************************************************************************************
  * @brief  UART_SendTab
  * @retval None
  ***********************************************************************************************************/
void UART_SendTab(void)
{
	URTxWriteIndex = sizeof(UART_Tab);
	memcpy(URTxBuf, UART_Tab, URTxWriteIndex);
	USART_IntConfig(COM1_PORT, USART_INT_TXDE, ENABLE);
	while(F_UR0TxComplete == 0){}
		F_UR0TxComplete = 0;
	memset(UART_Buffer, 0, sizeof(UART_Buffer));
}

/************************************************************************************************************
  * @brief  UART_SendComma    ","
  * @retval None
  ***********************************************************************************************************/
void UART_SendComma(void)
{
	URTxWriteIndex = sizeof(UART_Comma);
	memcpy(URTxBuf, UART_Comma, URTxWriteIndex);
	USART_IntConfig(COM1_PORT, USART_INT_TXDE, ENABLE);
	while(F_UR0TxComplete == 0){}
		F_UR0TxComplete = 0;
	memset(UART_Buffer, 0, sizeof(UART_Buffer));
}

/************************************************************************************************************
  * @brief  UART_SendData
  * @retval None
  ***********************************************************************************************************/
void UART_SendData(char *array, u8 length)
{
	URTxWriteIndex = length;
	memcpy(URTxBuf, array, URTxWriteIndex);
	USART_IntConfig(COM1_PORT, USART_INT_TXDE, ENABLE);
	while(F_UR0TxComplete == 0){}
		F_UR0TxComplete = 0;
	memset(UART_Buffer, 0, sizeof(UART_Buffer));
}



/************************************************************************************************************
  * @brief  Analysis_Command
  * @retval None
  ***********************************************************************************************************/
void Analysis_Command(void)
{
	if(F_UR0RxDataComing)
	{
		memset(URTxBuf, 0, sizeof(URTxBuf));
		memset(UART_Buffer, 0, sizeof(UART_Buffer));		
		UART_SendNEWLine();
				
		//************************AT**********************************//
		if(DataCompare(URRxWriteIndex,(u8*)&URRxBuf[0],(u8*)UART_AT))
		{	
			UART_SendData((char*)&UART_Receive_OK, sizeof(UART_Receive_OK));		
		}

		//************************Wrong Command**********************************//		
		else
		{
			UART_SendData((char*)&UART_Receive_CommandFail, sizeof(UART_Receive_CommandFail));
		}
		UART_SendNEWLine();
		F_UR0RxDataComing = 0;
		URRxWriteIndex = 0;
	}
	
}

/************************************************************************************************************
  * @brief  DataCompare
  * @retval None
  ***********************************************************************************************************/
bool DataCompare(u8 DataLen,u8 * ptrChar ,u8 * ptrChar2)
{
  u8 count;
	
	for(count=0;count<DataLen;count++)
	{
		if(ptrChar[count]!=ptrChar2[count])
		{
			return FALSE;
		}
	}
	return TRUE;		
}
